<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SettingLanguage extends Model 
{

    protected $table = 'lim_setting_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_setting_id', 'label', 'value', 'description');
    protected $visible = array('lim_language_id', 'lim_setting_id', 'label', 'value', 'description');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function setting()
    {
        return $this->belongsTo('App\Models\Setting', 'lim_setting_id');
    }

}